/*
SELECT * FROM PDV_CAMPANHA_ADICIONAIS
SELECT * FROM PDV_CAMPANHA_ADICIONAIS_EST_PROD
SELECT * FROM PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA
SELECT * FROM PDV_CAMPANHA_ADICIONAIS_PRC_FILIAL
*/

IF OBJECT_ID('V_PDV_CAMPANHA_ADICIONAIS_CARGA_PDV') IS NOT NULL
    DROP VIEW V_PDV_CAMPANHA_ADICIONAIS_CARGA_PDV;
GO

CREATE VIEW V_PDV_CAMPANHA_ADICIONAIS_CARGA_PDV
AS
     SELECT *
     FROM PDV_CAMPANHA_ADICIONAIS
     WHERE DT_VALID >= convert (VARCHAR ,GETDATE(),112);
GO

IF OBJECT_ID('V_PDV_CAMPANHA_ADICIONAIS_EST_PROD_CARGA_PDV') IS NOT NULL
    DROP VIEW V_PDV_CAMPANHA_ADICIONAIS_EST_PROD_CARGA_PDV;
GO

CREATE VIEW V_PDV_CAMPANHA_ADICIONAIS_EST_PROD_CARGA_PDV
AS
     SELECT CAMP_FIL.CD_EMP
          , CAMP_FIL.CD_FILIAL
          , CAMP_FIL.CD_CAMPANHA_ADIC
          , CAMP_CPL.CD_PROD
          , CAMP_CPL.QT_VENDA
          , CAMP_CPL.DT_CAD
          , CAMP_CPL.VLR_VENDA
     FROM
          PDV_CAMPANHA_ADICIONAIS CAMP_ADIC
          INNER JOIN PDV_CAMPANHA_ADICIONAIS_PRC_FILIAL CAMP_FIL
          ON CAMP_ADIC.CD_EMP = CAMP_FIL.CD_EMP
             AND CAMP_ADIC.CD_CAMPANHA_ADIC = CAMP_FIL.CD_CAMPANHA_ADIC
          INNER JOIN PDV_CAMPANHA_ADICIONAIS_EST_PROD CAMP_CPL
          ON CAMP_FIL.CD_EMP = CAMP_FIL.CD_EMP
             AND CAMP_FIL.CD_CAMPANHA_ADIC = CAMP_CPL.CD_CAMPANHA_ADIC
     WHERE CAMP_ADIC.DT_VALID >= CONVERT(date ,GETDATE())
           AND CAMP_ADIC.STATUS_CAMPANHA = 0;
GO

IF OBJECT_ID('V_PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA_CARGA_PDV') IS NOT NULL
    DROP VIEW V_PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA_CARGA_PDV;
GO

CREATE VIEW V_PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA_CARGA_PDV
AS
     SELECT CAMP_FIL.CD_EMP
          , CAMP_FIL.CD_FILIAL
          , CAMP_FIL.CD_CAMPANHA_ADIC
          , CAMP_CPL.CD_PROD
          , CAMP_CPL.QTDE_PROD
     FROM
          PDV_CAMPANHA_ADICIONAIS CAMP_ADIC
          INNER JOIN PDV_CAMPANHA_ADICIONAIS_PRC_FILIAL CAMP_FIL
          ON CAMP_ADIC.CD_EMP = CAMP_FIL.CD_EMP
             AND CAMP_ADIC.CD_CAMPANHA_ADIC = CAMP_FIL.CD_CAMPANHA_ADIC
          INNER JOIN PDV_CAMPANHA_ADICIONAIS_EST_PROD_CAMPANHA CAMP_CPL
          ON CAMP_FIL.CD_EMP = CAMP_FIL.CD_EMP
             AND CAMP_FIL.CD_CAMPANHA_ADIC = CAMP_CPL.CD_CAMPANHA_ADIC
     WHERE 
	   CAMP_ADIC.DT_VALID >= CONVERT(date ,GETDATE())
	   AND CAMP_ADIC.STATUS_CAMPANHA = 0;